/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.utils;

import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.core.model.ISourceProject;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.indexer.EntryUtils;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.internal.builder.BuildPathManager;
import com.aptana.editor.php.internal.builder.ProjectBuildPath;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.model.ISourceFolder;
import com.aptana.editor.php.internal.model.ITypeHierarchy;
import com.aptana.editor.php.internal.model.impl.EntryBasedField;
import com.aptana.editor.php.internal.model.impl.EntryBasedMethod;
import com.aptana.editor.php.internal.model.impl.EntryBasedType;
import com.aptana.editor.php.internal.model.impl.SourceFolder;
import com.aptana.editor.php.internal.model.impl.SourceModule;
import com.aptana.editor.php.internal.model.impl.SourceProject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org2.eclipse.php.core.compiler.PHPFlags;

public class ModelUtils {
    public static IModelElement convertEntry(IElementEntry entry) {
        if (EntryUtils.isType(entry)) {
            return new EntryBasedType(entry);
        }
        if (EntryUtils.isFunction(entry)) {
            return new EntryBasedMethod(entry);
        }
        if (EntryUtils.isField(entry)) {
            return new EntryBasedField(entry);
        }
        return null;
    }

    public static ISourceModule convertModule(IModule module) {
        if (module == null) {
            return null;
        }
        return new SourceModule(module);
    }

    public static ISourceFolder convertFolder(IDirectory dir) {
        if (dir == null) {
            return null;
        }
        return new SourceFolder(dir);
    }

    public static ISourceProject convertBuildPath(IBuildPath buildPath) {
        if (buildPath instanceof ProjectBuildPath) {
            return new SourceProject((ProjectBuildPath)buildPath);
        }
        return null;
    }

    public static ISourceModule getModule(IFile file) {
        IModule module = BuildPathManager.getInstance().getModuleByResource(file);
        if (module != null) {
            return ModelUtils.convertModule(module);
        }
        return null;
    }

    public static List<IModelElement> convertEntries(List<IElementEntry> entries) {
        if (entries == null || entries.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        for (IElementEntry entry : entries) {
            IModelElement element = ModelUtils.convertEntry(entry);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static List<IType> convertTypes(List<IElementEntry> entries) {
        if (entries == null || entries.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IType> result = new ArrayList<IType>();
        for (IElementEntry entry : entries) {
            IModelElement element;
            if (entry.getCategory() != 1 || (element = ModelUtils.convertEntry(entry)) == null) continue;
            result.add((IType)element);
        }
        return result;
    }

    public static List<IType> convertClasses(List<IElementEntry> entries) {
        if (entries == null || entries.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IType> result = new ArrayList<IType>();
        for (IElementEntry entry : entries) {
            IModelElement element;
            if (entry.getCategory() != 1 || PHPFlags.isInterface((int)((ClassPHPEntryValue)entry.getValue()).getModifiers()) || (element = ModelUtils.convertEntry(entry)) == null) continue;
            result.add((IType)element);
        }
        return result;
    }

    public static List<IType> convertInterfaces(List<IElementEntry> entries) {
        if (entries == null || entries.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IType> result = new ArrayList<IType>();
        for (IElementEntry entry : entries) {
            IModelElement element;
            if (entry.getCategory() != 1 || !PHPFlags.isInterface((int)((ClassPHPEntryValue)entry.getValue()).getModifiers()) || (element = ModelUtils.convertEntry(entry)) == null) continue;
            result.add((IType)element);
        }
        return result;
    }

    public static boolean isSuperType(ITypeHierarchy hierarchy, IType possibleSuperType, IType type) {
        List<IType> superClass = hierarchy.getSuperclass(type);
        if (superClass != null) {
            int q = 0;
            while (q < superClass.size()) {
                if (possibleSuperType.equals(superClass.get(q)) || ModelUtils.isSuperType(hierarchy, possibleSuperType, superClass.get(q))) {
                    return true;
                }
                ++q;
            }
        }
        return false;
    }

    private ModelUtils() {
    }
}

